//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#property indicator_separate_window
#property indicator_buffers 11
//---
#property indicator_color1  clrSlateBlue
#property indicator_color2  clrDarkGray
#property indicator_color3  clrDarkOrange
#property indicator_color4  clrGoldenrod
#property indicator_color11 clrWhite
//---
#property indicator_style2  STYLE_DOT
#property indicator_style2  STYLE_DOT
//---
#property indicator_width11 2
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
extern ENUM_TIMEFRAMES TimeFrame               = PERIOD_CURRENT;
extern ENUM_TIMEFRAMES TimeFrameOP             = PERIOD_D1;    
extern int             RSIPeriod               = 14;
extern int             BandPeriod              = 20;
extern double          BandDeviation           = 1.3185;
extern color           ColorUp                 = clrLimeGreen;   // Color for up
extern color           ColorDown               = clrRed;         // Color for down
extern int             LineWidth               = 3;              // Main line width
extern int             ShadowWidth             = 3;              // Shadow width (<=0 main line width+3) 
extern bool            verticalLinesVisible    = false;
extern string          verticalLinesID         = "rsiBbLines1";
extern color           verticalLinesUpColor    = clrDeepSkyBlue;
extern color           verticalLinesDownColor  = clrPaleVioletRed;
extern ENUM_LINE_STYLE verticalLinesStyle      = STYLE_DOT;
extern int             verticalLinesWidth      = 0;
extern bool            verticalLinesOnFirstBar = true;
extern bool            alertsOn                = true;
extern bool            alertsOnMiddleBandCross = true;
extern bool            alertsOnOuterBandsCross = true;
extern bool            alertsOnCurrent         = true;
extern bool            alertsMessage           = true;
extern bool            alertsSound             = false;
extern bool            alertsNotify            = false;
extern bool            alertsEmail             = false;
extern string          soundFile               = "alert2.wav";
extern bool            arrowsVisible           = false;               // Arrows visible?
extern bool            arrowsOnNewest          = false;               // Arrows drawn on newest bar of higher time frame bar?
extern string          arrowsIdentifier        = "rsi Arrows1";       // Unique ID for arrows
extern double          arrowsUpperGap          = 1.0;                 // Upper arrow gap
extern double          arrowsLowerGap          = 1.0;                 // Lower arrow gap
extern color           arrowsUpColor           = clrLimeGreen;        // Up arrow color
extern color           arrowsDnColor           = clrOrange;           // Down arrow color
extern int             arrowsUpCode            = 241;                 // Up arrow code
extern int             arrowsDnCode            = 242;                 // Down arrow code
extern int             arrowsSize              = 0;                   // Arrows size
extern bool            Interpolate             = true;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double rsi[],buffer1da[],buffer1db[],buffer1ua[],buffer1ub[],shadowa[],shadowb[],UpZone[],DnZone[],Ma[],trend[],cross[], LNOPEN[];
string IndukName;
bool   returnBars;
int    timeFrame;
//---
int MAX, TFK1, TFK2, MTK, ARB, SGB, TikKont=1, ReCalc=1;   string sTFR1, sTFR2, cTFR, TWIN, PREF;   datetime TimeBar=0, NewTime=0, OneTime=0;    bool boBand=false, boHist=false, yesBars=false;       
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
{
   TimeFrame = fmax(TimeFrame,_Period);      TFK1 = TimeFrame/_Period;    sTFR1 = StringSubstr(EnumToString(TimeFrame),7);   cTFR = StringSubstr(EnumToString(ENUM_TIMEFRAMES(_Period)),7);  //IndukName = WindowExpertName();                                                          
   TimeFrameOP = fmax(TimeFrameOP,_Period);  TFK2 = TimeFrameOP/_Period;  sTFR2 = StringSubstr(EnumToString(TimeFrameOP),7);        
   //---
   int shadowWidth = (ShadowWidth<=0) ? LineWidth+3 : ShadowWidth;
   //---
   IndicatorBuffers(13);
   //---
   SetIndexBuffer(0, UpZone);
   SetIndexBuffer(1, Ma);
   SetIndexBuffer(2, DnZone);
   SetIndexBuffer(3, rsi);        SetIndexStyle(3,EMPTY,EMPTY,LineWidth);
   SetIndexBuffer(4, shadowa);    SetIndexStyle(4,EMPTY,EMPTY,ShadowWidth);
   SetIndexBuffer(5, shadowb);    SetIndexStyle(5,EMPTY,EMPTY,ShadowWidth);
   SetIndexBuffer(6, buffer1ua);  SetIndexStyle(6,EMPTY,EMPTY,LineWidth,ColorUp);
   SetIndexBuffer(7, buffer1ub);  SetIndexStyle(7,EMPTY,EMPTY,LineWidth,ColorUp);
   SetIndexBuffer(8, buffer1da);  SetIndexStyle(8,EMPTY,EMPTY,LineWidth,ColorDown);
   SetIndexBuffer(9, buffer1db);  SetIndexStyle(9,EMPTY,EMPTY,LineWidth,ColorDown);
   //---
   SetIndexBuffer(10,LNOPEN);     SetIndexStyle(10,DRAW_LINE);   SetIndexLabel(10,sTFR2+": Open line "); 
   //---
   for (int i=0; i<11; i++) {
     SetIndexStyle(i,DRAW_LINE);
     SetIndexEmptyValue(i,EMPTY_VALUE); }
   //---
   SetIndexBuffer(11,trend);
   SetIndexBuffer(12,cross);
    //
    //
    IndukName = WindowExpertName();
    //returnBars        = TimeFrame == "returnBars";     if (returnBars)     return(0);
    //TimeFrame         = stringToTimeFrame(TimeFrame);
    //
    //
    IndicatorShortName(TimeFrameToString(TimeFrame)+" Rsi bands");
//---
return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int deinit()
{
   string lookFora        = arrowsIdentifier+":";
    int    lookForLengtha = StringLen(lookFora);
    for (int i=ObjectsTotal()-1; i>=0; i--)
    {
       string objectNamea = ObjectName(i);
          if (StringSubstr(objectNamea,0,lookForLengtha) == lookFora) ObjectDelete(objectNamea);
    }
   string lookFor       = verticalLinesID+":";
   int    lookForLength = StringLen(lookFor);
   for (i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
   return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { UpZone[0] = limit+1; return(0); }
int y2=0, x2=0, w2=0;           
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
           if (TimeFrame!=_Period)  //&& TimeFrameOP!=_Period)  
            {
             limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,TimeFrame,IndukName,0,0,0)*TimeFrame/_Period));
             
             if (trend[limit]==-1) { CleanPoint(limit,buffer1da,buffer1db); CleanPoint(limit,shadowa,shadowb); }
             if (trend[limit]== 1) { CleanPoint(limit,buffer1ua,buffer1ub); CleanPoint(limit,shadowa,shadowb); }
             
             for (int i=limit; i>=0; i--)
             {
              int y = iBarShift(NULL,TimeFrame,Time[i]);               
                 
                 UpZone[i] = iCustom(NULL,TimeFrame,IndukName,PERIOD_CURRENT,PERIOD_CURRENT,RSIPeriod,BandPeriod,BandDeviation,ColorUp,ColorDown,LineWidth,ShadowWidth,verticalLinesVisible,verticalLinesID,verticalLinesUpColor,verticalLinesDownColor,verticalLinesStyle,verticalLinesWidth,verticalLinesOnFirstBar,alertsOn,alertsOnMiddleBandCross,alertsOnOuterBandsCross,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsSize,0, y);
                 Ma[i]     = iCustom(NULL,TimeFrame,IndukName,PERIOD_CURRENT,PERIOD_CURRENT,RSIPeriod,BandPeriod,BandDeviation,ColorUp,ColorDown,LineWidth,ShadowWidth,verticalLinesVisible,verticalLinesID,verticalLinesUpColor,verticalLinesDownColor,verticalLinesStyle,verticalLinesWidth,verticalLinesOnFirstBar,alertsOn,alertsOnMiddleBandCross,alertsOnOuterBandsCross,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsSize,1, y); 
                 DnZone[i] = iCustom(NULL,TimeFrame,IndukName,PERIOD_CURRENT,PERIOD_CURRENT,RSIPeriod,BandPeriod,BandDeviation,ColorUp,ColorDown,LineWidth,ShadowWidth,verticalLinesVisible,verticalLinesID,verticalLinesUpColor,verticalLinesDownColor,verticalLinesStyle,verticalLinesWidth,verticalLinesOnFirstBar,alertsOn,alertsOnMiddleBandCross,alertsOnOuterBandsCross,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsSize,2, y);
                 rsi[i]    = iCustom(NULL,TimeFrame,IndukName,PERIOD_CURRENT,PERIOD_CURRENT,RSIPeriod,BandPeriod,BandDeviation,ColorUp,ColorDown,LineWidth,ShadowWidth,verticalLinesVisible,verticalLinesID,verticalLinesUpColor,verticalLinesDownColor,verticalLinesStyle,verticalLinesWidth,verticalLinesOnFirstBar,alertsOn,alertsOnMiddleBandCross,alertsOnOuterBandsCross,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsSize,3, y);
                 trend[i]  = iCustom(NULL,TimeFrame,IndukName,PERIOD_CURRENT,PERIOD_CURRENT,RSIPeriod,BandPeriod,BandDeviation,ColorUp,ColorDown,LineWidth,ShadowWidth,verticalLinesVisible,verticalLinesID,verticalLinesUpColor,verticalLinesDownColor,verticalLinesStyle,verticalLinesWidth,verticalLinesOnFirstBar,alertsOn,alertsOnMiddleBandCross,alertsOnOuterBandsCross,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsSize,11,y);  
                 //---
                 buffer1da[i] = EMPTY_VALUE;
                 buffer1db[i] = EMPTY_VALUE;
                 buffer1ua[i] = EMPTY_VALUE;
                 buffer1ub[i] = EMPTY_VALUE;
                 shadowa[i]   = EMPTY_VALUE;
                 shadowb[i]   = EMPTY_VALUE;        
                 //---
                 if (!Interpolate || ((i>0) && y==iBarShift(NULL,TimeFrame,Time[(int)MathMax(i-1,0)]))) continue;
                 int n,x; datetime time = iTime(NULL,TimeFrame,y);
                 for(n = 1; (i+n)<(Bars-1) && Time[i+n] >= time; n++) continue;	
                 for(x = 1; x < n && (i+x)<Bars; x++)
                  {
                   rsi[i+x]    = rsi[i]    + (rsi[i+n]    - rsi[i])    * x/n;
                   UpZone[i+x] = UpZone[i] + (UpZone[i+n] - UpZone[i]) * x/n;
                   DnZone[i+x] = DnZone[i] + (DnZone[i+n] - DnZone[i]) * x/n;
                   Ma[i+x]     = Ma[i]     + (Ma[i+n]     - Ma[i]    ) * x/n;
                  }
               }
               
               for(i=limit; i>=0; i--)
                {
                 if (trend[i] == -1) { PlotPoint(i,buffer1da,buffer1db,rsi); PlotPoint(i,shadowa,shadowb,rsi); }
                 if (trend[i] ==  1) { PlotPoint(i,buffer1ua,buffer1ub,rsi); PlotPoint(i,shadowa,shadowb,rsi); } 
                 //---
                 LNOPEN[i]=EMPTY_VALUE;   
                 //---
                 if (TimeFrameOP!=_Period)  
                  {     LNOPEN[i]=LNOPEN[i+1];  
                   y2 = iBarShift(NULL,TimeFrameOP,Time[i]);    
                   x2 = y2;  if (i<iBars(NULL,0)-1) x2 = iBarShift(NULL,TimeFrameOP,iTime(NULL,0,i+1));   
                   w2 = y2;  if (i<iBars(NULL,0)-1) w2 = iBarShift(NULL,TimeFrameOP,iTime(NULL,0,i-1));   
                   //---
                   if (y2!=0 && y2!=w2)  LNOPEN[i] = EMPTY_VALUE;
                   if (x2!=y2)           LNOPEN[i] = rsi[i];  //iStochastic(NULL,TimeFrameOP,KPeriod,DPeriod,Slowing,MAMethod,PriceField,MODE_MAIN,y2);
                  }
               //---
                }
             return(0);
            }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
   if (trend[limit]==-1) { CleanPoint(limit,buffer1da,buffer1db); CleanPoint(limit,shadowa,shadowb); }
   if (trend[limit]== 1) { CleanPoint(limit,buffer1ua,buffer1ub); CleanPoint(limit,shadowa,shadowb); }
   //---
   for(i=limit; i>=0; i--) 
    {
     rsi[i] = iRSI(NULL,0,RSIPeriod,PRICE_WEIGHTED,i);
     //---
     LNOPEN[i]=EMPTY_VALUE;   
     //---
     if (TimeFrameOP!=_Period)  
      {     LNOPEN[i]=LNOPEN[i+1];   
       y2 = iBarShift(NULL,TimeFrameOP,iTime(NULL,0,i),false);      
       x2 = y2;  if (i<iBars(NULL,0)-1) x2 = iBarShift(NULL,TimeFrameOP,iTime(NULL,0,i+1));   //if (i>iBars(NULL,TimeFrame)-3) continue;
       w2 = y2;  if (i<iBars(NULL,0)-1) w2 = iBarShift(NULL,TimeFrameOP,iTime(NULL,0,i-1));   //if (z!=0 && z!=w) continue;  //TimeFrame!=_Period &&     
       //---
       if (y2!=0 && y2!=w2)  LNOPEN[i] = EMPTY_VALUE;
       if (x2!=y2)           LNOPEN[i] = rsi[i];  //iStochastic(NULL,TimeFrameOP,KPeriod,DPeriod,Slowing,MAMethod,PriceField,MODE_MAIN,y2);
      }
    }
   //---
   //---
   for(i=limit; i>=0; i--) 
   {
      double dev   = iStdDevOnArray(rsi,0,BandPeriod,0,MODE_SMA,i);
         Ma[i]     = iMAOnArray(rsi,0,BandPeriod,0,MODE_SMA,i);
         UpZone[i] = Ma[i] + BandDeviation * dev;
         DnZone[i] = Ma[i] - BandDeviation * dev;  
         buffer1da[i] = EMPTY_VALUE;
         buffer1db[i] = EMPTY_VALUE;
         buffer1ua[i] = EMPTY_VALUE;
         buffer1ub[i] = EMPTY_VALUE;
         shadowa[i]   = EMPTY_VALUE;
         shadowb[i]   = EMPTY_VALUE;
         trend[i] =              (rsi[i]>UpZone[i]) ? 1 : (rsi[i]<DnZone[i]) ? -1 : 0;
         cross[i] = (i<Bars-1) ? (rsi[i]>Ma[i])     ? 1 : (rsi[i]<Ma[i])     ? -1 : cross[i+1] : 0;
         if (trend[i] == -1) { PlotPoint(i,buffer1da,buffer1db,rsi); PlotPoint(i,shadowa,shadowb,rsi); }
         if (trend[i] ==  1) { PlotPoint(i,buffer1ua,buffer1ub,rsi); PlotPoint(i,shadowa,shadowb,rsi); }  
         //
         //
         if (arrowsVisible)
         {
            string lookFor = arrowsIdentifier+":"+(string)Time[i]; ObjectDelete(lookFor);            
            if (i<(Bars-1) && cross[i] != cross[i+1])
            {
               if (cross[i] == 1) drawArrow(i,arrowsUpColor,arrowsUpCode,false);
               if (cross[i] ==-1) drawArrow(i,arrowsDnColor,arrowsDnCode, true);
             }
         }
         manageLines(i);
   }
   //
   //
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
      static datetime time1 = 0;
      static string   mess1 = "";
         if (alertsOnMiddleBandCross && cross[whichBar] != cross[whichBar+1])
         {
            if (cross[whichBar] ==  1) doAlert(time1,mess1,whichBar," crossing middle band up ");
            if (cross[whichBar] == -1) doAlert(time1,mess1,whichBar," crossing middle band down ");
         }            
      static datetime time2 = 0;
      static string   mess2 = "";
         if (alertsOnOuterBandsCross && trend[whichBar] != trend[whichBar+1])
         {
            if (trend[whichBar] ==  1) doAlert(time2,mess2,whichBar," crossing upper band ");
            if (trend[whichBar] == -1) doAlert(time2,mess2,whichBar," crossing lower band ");
         }  
               
   }     
return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i]; first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] = from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                          second[i] = EMPTY_VALUE; }
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string sTfTable[] = {"M1","M5","M10","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,10,15,30,60,240,1440,10080,43200};
//---
int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],_Period));
                                                      return(_Period);
}
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
string TimeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void manageLines(int i)
{
   if (verticalLinesVisible )
   {
      ObjectDelete(verticalLinesID+":"+Time[i]);   
         if (trend[i]!=trend[i+1])
         {
            if (trend[i] == 1) drawLine(i,verticalLinesUpColor);
            if (trend[i] ==-1) drawLine(i,verticalLinesDownColor);
         }
   }
}               
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void drawLine(int i,color theColor)
{
   string name = verticalLinesID+":"+Time[i];
      //
      //
      int diff = 0; if (!verticalLinesOnFirstBar) diff=_Period*60-1;
      ObjectCreate(name,OBJ_VLINE,0,Time[i]+diff,0);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         ObjectSet(name,OBJPROP_STYLE,verticalLinesStyle);
         ObjectSet(name,OBJPROP_WIDTH,verticalLinesWidth);
         ObjectSet(name,OBJPROP_BACK,true);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void deleteLine(datetime time)
{
   
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void doAlert(datetime& previousTime, string& previousAlert, int forBar, string doWhat)
{
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];
          //
          //
          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," ",TimeFrameToString(_Period)+" Rsi  ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Rsi "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void drawArrow(int i,color theColor,int theCode,bool tup)
{
   string name = arrowsIdentifier+":"+(string)Time[i];
   double gap  = iATR(NULL,0,20,i);   
      //
      //
      datetime time = Time[i]; if (arrowsOnNewest) time += _Period*60-1;      
      ObjectCreate(name,OBJ_ARROW,0,time,0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_WIDTH,arrowsSize);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         ObjectSet(name,OBJPROP_SELECTABLE,false);
         
         if (tup)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+